from QtTest import Ui_MainWindow
import sys
import os
from PyQt5.QtWidgets import QApplication,QMainWindow,QFileDialog
from PyQt5.QtCore import QTimer,QCoreApplication
from PyQt5.QtGui import QPixmap
from PyQt5 import QtGui
import cv2
# import qimage2ndarray
import time
import pyrealsense2 as rs
import numpy as np


class CamShow(QMainWindow, Ui_MainWindow):
    def __init__(self, parent=None):
        super(CamShow, self).__init__(parent)
        self.setupUi(self)
        self.prepareWidgets()
        self.prepareParameters()
        self.CallBackFunctions()
        self.Timer = QTimer()
        self.Timer.timeout.connect(self.TimerOutRun)

    def prepareWidgets(self):
        self.videoLabels = [self.videoLabel1, self.videoLabel2]

        self.prepareCameras()
        self.pauseButton.setEnabled(False)
        self.saveButton.setEnabled(False)

    def initCamera(self, camera_idx):
        try:
            config = rs.config()
            config.enable_device(camera_idx)
            config.enable_stream(rs.stream.depth, 640, 480, rs.format.z16, 30)
            config.enable_stream(rs.stream.color, 640, 480, rs.format.bgr8, 30)
            return config
        except Exception as e:
            self.textEdit.clear()
            self.textEdit.append(str(e))
            return None

    def prepareCameras(self, max_camera_num=2):
        realsense_ctx = rs.context()
        self.connected_devices = []
        for i in range(len(realsense_ctx.devices)):
            detected_camera = realsense_ctx.devices[i].get_info(rs.camera_info.serial_number)
            self.connected_devices.append(detected_camera)
        self.cameras = []
        for i in range(min(len(self.connected_devices), max_camera_num)):
            config = self.initCamera(self.connected_devices[i])
            if config:
                self.cameras.append((rs.pipeline(), config))
        self.textEdit.setText('{} cameras has been connected.'.format(len(self.cameras)))

    def prepareParameters(self):
        self.record_flag = 0
        self.save_path = os.path.join(os.path.expanduser('~'), 'realsense_video/')
        self.lineEdit.setText(self.save_path)

    def CallBackFunctions(self):
        self.pushButton_3.clicked.connect(self.SetFilePath)
        self.beginButton.clicked.connect(self.StartCameras)
        self.pauseButton.clicked.connect(self.StopCameras)
        self.quitButton.clicked.connect(self.exitApp)
        self.saveButton.clicked.connect(self.RecordCamera)

    def StartCameras(self):
        self.beginButton.setEnabled(False)
        self.pauseButton.setEnabled(True)
        self.saveButton.setEnabled(True)
        self.saveButton.setText('录像')
        for camera in self.cameras:
            camera[0].start(camera[1])
        self.Timer.start(1)
        # self.timelb = time.clock()

    def StopCameras(self):
        if self.pauseButton.text() == '暂停':
            self.pauseButton.setText('继续')
            self.saveButton.setText('保存')
            self.saveButton.setEnabled(False)
            self.Timer.stop()
        elif self.pauseButton.text() == '继续':
            self.pauseButton.setText('暂停')
            self.saveButton.setText('录像')
            self.saveButton.setEnabled(True)
            self.Timer.start(1)

    def TimerOutRun(self):
        for idx, camera in enumerate(self.cameras):
            pipeline = camera[0]
            frames = pipeline.wait_for_frames()
            depth_frame = frames.get_depth_frame()
            color_frame = frames.get_color_frame()
            if not depth_frame or not color_frame:
                continue
            # Convert images to numpy arrays
            depth_image = np.asanyarray(depth_frame.get_data())
            color_image = np.asanyarray(color_frame.get_data())
            # print(color_image.shape)
            # Apply colormap on depth image (image must be converted to 8-bit per pixel first)
            depth_colormap = cv2.applyColorMap(cv2.convertScaleAbs(depth_image, alpha=0.03), cv2.COLORMAP_JET)

            # Stack both images horizontally
            images = np.hstack((color_image, depth_colormap))
            show = cv2.resize(color_image, (640, 480))
            show = cv2.cvtColor(show, cv2.COLOR_BGR2RGB)

            self.DispImg(show, idx)
            if self.record_flag:
                self.video_writer[idx].write(color_image)
                self.depth_writer[idx].write(depth_image)

    def DispImg(self, show, camera_idx):
        showImage = QtGui.QImage(show.data, show.shape[1], show.shape[0], QtGui.QImage.Format_RGB888)
        self.videoLabels[camera_idx].setPixmap(QtGui.QPixmap.fromImage(showImage))
        self.videoLabels[camera_idx].show()

    def SetFilePath(self):
        dirname = QFileDialog.getExistingDirectory(self, "浏览", '.')
        if dirname:
            self.lineEdit.setText(dirname)
            self.save_path = dirname+'/'

    def RecordCamera(self):
        tag = self.saveButton.text()
        if not os.path.exists(self.save_path):
            os.makedirs(self.save_path)
        if tag == '录像':
            self.Timer.stop()
            self.saveButton.setText('停止')
            str_time = time.strftime('%Y%m%d%H%M%S', time.localtime(time.time()))
            video_names = [self.save_path + 'color_camera' + str(i+1)+'_'
                           + str_time + '.mp4' for i in range(len(self.cameras))]
            depth_names = [video_name.replace('color', 'depth').replace('mp4', 'depth') for video_name in video_names]
            print(video_names)
            # size = (self.Image.shape[1],self.Image.shape[0])
            # fourcc = cv2.VideoWriter_fourcc('M', 'J', 'P', 'G')
            fourcc = cv2.VideoWriter_fourcc(*'PIM1')
            fps = 30
            size = (640, 480)

            self.video_writer = [cv2.VideoWriter(video_name, fourcc, fps, size) for video_name in video_names]
            self.depth_writer = [open(depth_name, 'wb') for depth_name in depth_names]
            self.record_flag = 1
            self.textEdit.setText('Video recording...')
            self.Timer.start(1)
            self.pauseButton.setEnabled(False)
            self.quitButton.setEnabled(False)
        elif tag == '停止':
            self.Timer.stop()
            self.saveButton.setText('录像')
            self.record_flag = 0
            self.Timer.start(1)
            [video_writer.release() for video_writer in self.video_writer]
            [depth_writer.close() for depth_writer in self.depth_writer]
            self.textEdit.setText('Video saved.')
            self.pauseButton.setEnabled(True)
            self.quitButton.setEnabled(True)

    def exitApp(self):
        self.Timer.stop()
        self.textEdit.setText('Exiting the application..')
        try:
            [camera[0].stop() for camera in self.cameras]
        except Exception as e:
            pass
        QCoreApplication.quit()








if __name__ == '__main__':
    app = QApplication(sys.argv)
    ui=CamShow()
    ui.show()
    sys.exit(app.exec_())
