# 训练
```
python train_token_classification.py -src_data data/pinyin_new_split.txt -trg_data data/hanzi_new_split.txt -epochs 100 -model_name token_classification_split_new -src_voc ./data/voc/pinyin.txt -trg_voc ./data/voc/hanzi.txt 
```
parameters:
- -src_data 拼音文件
- -trg_data 汉字文件
- -epochs 训练epoch
- -model_name 模型名称
- -src_voc 拼音字典
- -trg_voc 汉字字典
- -batchsize 默认64

# 验证集验证模型
```
python eval_model.py -pkl_dir weights/token_classification_split_new/11-28_14:53:18/ -dev_dir data/dev -src_voc ./data/voc/pinyin.txt -trg_voc ./data/voc/hanzi.txt -model_name token_classification_split_new
```
parameters:
- -pkl_dir 存储pkl（Filed对象）的目录
- -dev_dir 验证集存储目录
- -model_name 模型名称
- -src_voc 拼音字典
- -trg_voc 汉字字典

# 测试
```
python translate_file2.py -load_weights weights/token_classification_split_new/11-28_14:53:18/token_classification_split_new_26_0.025378503443207592 -pkl_dir weights/token_classification_split_new/11-28_14:53:18 -test_dir data/test_data/split_new_data_daoxuehao/pinyin_random_change_tones -result_dir data/test_data/split_new_data_daoxuehao/result_random_change_tones -src_voc ./data/voc/pinyin.txt -trg_voc ./data/voc/hanzi.txt
```

parameters:
- -load_weights：模型存储路径
- -pkl_dir 存储pkl（Filed对象）的目录
- -test_dir 测试集目录
- -result_dir 翻译结果存储目录
- -src_voc 拼音字典
- -trg_voc 汉字字典