import argparse
import json
import os

from PIL import Image, ImageDraw, ImageFont

parser = argparse.ArgumentParser()
parser.add_argument('--json_path',type=str,required=True, help='report.json的路径')
# 解析命令行参数
args = parser.parse_args()

def main():
    rule_name_example = [
            "验证码",
            "非文本链接",
            "非文本控件",
            "多媒体",
            "功能性组件访问",
            "装饰性内容访问",
            "非装饰性组件",
            "漂浮窗",
            "闪光",
            "焦点顺序",
            "错误原因提示",
            "验证码",
            "浮窗"
        ]
    print('条目名称示例：'+','.join(rule_name_example))
    rules_select_input = input("请输入你要检测的条目名称，用英文逗号分隔：")

    selected_rules = rules_select_input.split(',')
    print('条目名称识别结果：',selected_rules)

    json_path = args.json_path
    print(json_path)
    output_image_path=os.path.join(os.path.curdir,'temp.png')

    # json_path = "app_report.json"
    with open(json_path,'r') as f:
        data = json.load(f)
        for item in data:
            page = data[item]
            img_name = page["图片名"]
            img_path = page["原始绝对路径"]
            all_rules = page["所有条目"]
            all_check_result = page["通过情况"]
            for rule_id,rule in enumerate(all_rules):
                if rule in selected_rules:
                    user_input = input("请输入 'n' 继续遍历下一个，输入 'c' 结束遍历: ")
                    if user_input == 'c':
                        print("程序已结束。")
                        return 0
                    elif user_input == 'n':
                        # 获取当前键值对
                        value = all_check_result[rule_id]
                        img = Image.open(img_path)
                        width,height = img.size
                        draw = ImageDraw.Draw(img)
                        # font = ImageFont.load_default()
                        font_path = "华文仿宋.ttf"  # 替换为实际字体文件路径
                        font_size = width/20  # 设定字体大小
                        font = ImageFont.truetype(font_path, font_size)
                        # draw.text((0,0), img_path, fill=(255,0,0),font=font)
                        print(f'当前展示图片：{img_name}')
                        print(f'当前展示图片原始路径：{img_path}')
                        if value:
                            draw.text((0,0), all_rules[rule_id]+": 不通过", fill=(255,0,0),font=font)
                        else:
                            draw.text((0,0), all_rules[rule_id]+": 通过", fill=(255,0,0),font=font)
                        img.save(output_image_path)
                        print(f"已将检测结果展示在 {output_image_path}")
                    else:
                        print("输入无效，请输入 'n' 或 'c'。")
if __name__=="__main__":
    main()