import os

# 读取文件并按要求处理
def process_file(file_path, output_path):
    with open(file_path, 'r') as file:
        lines = file.readlines()


    # 处理每行，将第一列数字移到最后，并排序
    processed_lines = []
    for id, line in enumerate(lines):
        parts = line.split()  # 将每行按空格分割
        if len(parts) > 1:
            # 将第一列数字移到最后
            number = parts[0]
            text = ' '.join(parts[1:])
            processed_lines.append((id, text, int(number), ))  # 用元组存储数字和文本

    # 按照第一列的数字从大到小排序
    processed_lines.sort(reverse=False, key=lambda x: x[2])

    # 写入处理后的内容到输出文件
    with open(output_path, 'w') as output_file:
        for _, number, text in processed_lines:
            output_file.write(f"{text} {number}\n")

# 传入输入文件路径和输出文件路径
input_file = 'app_map.txt'   # 输入文件路径
output_file = 'output.txt' # 输出文件路径

# 执行函数
process_file(input_file, output_file)

print("文件处理完成，已按照要求排序并保存到 'output.txt'")