import cv2
import numpy as np
import matplotlib.pyplot as plt

import imageio

from PIL import Image
import os
from pathlib import Path
import json
import csv
from jsonpath import jsonpath
import math
import cv2
import imageio
#滤波操作
class MovAvg(object):
    def __init__(self, window_size=10):
        self.window_size = window_size
        self.data_queue = []
    def update(self, data):
        if len(self.data_queue) == self.window_size:
            del self.data_queue[0]
        #if data>0:
        self.data_queue.append(data)
        return sum(self.data_queue)/len(self.data_queue)

def changejointupper(pose,jointlist):
    for jointindex in jointlist:
        if (jointindex+3) not in jointlist:
            continue
        if pose[jointindex,0]>pose[jointindex+3,0]:
            pose[jointindex, 0],pose[jointindex + 3, 0]=pose[jointindex + 3, 0],pose[jointindex, 0]
            pose[jointindex, 1], pose[jointindex + 3, 1] = pose[jointindex + 3, 1], pose[jointindex, 1]

def changejointlower(pose,jointlist):
    for jointindex in jointlist:
        if (jointindex+3) not in jointlist:
            continue
        if pose[jointindex,0]<pose[jointindex+3,0]:
            pose[jointindex, 0],pose[jointindex + 3, 0]=pose[jointindex + 3, 0],pose[jointindex, 0]
            pose[jointindex, 1], pose[jointindex + 3, 1] = pose[jointindex + 3, 1], pose[jointindex, 1]

def selectjointdistance(PoseX,PoseY,jointlist):
    newPoseX=[]
    newPoseY=[]
    for jointindex in jointlist:
        #PoseX[jointindex]=updateArray(deleterror(searcherror(PoseX[jointindex]), PoseX[jointindex]))
        #PoseY[jointindex] = updateArray(deleterror(searcherror(PoseY[jointindex]), PoseY[jointindex]))
        #PoseX[jointindex]=deleterror(searcherror(PoseX[jointindex]), PoseX[jointindex])
        #PoseY[jointindex] = deleterror(searcherror(PoseY[jointindex]), PoseY[jointindex])
        newPoseX.append(PoseX[jointindex])
        newPoseY.append(PoseY[jointindex])
    return computedistance(np.array(newPoseX),np.array(newPoseY))

def selectjointdistancestd(PoseX,PoseY,jointlist):
    newPoseX=[]
    newPoseY=[]
    for jointindex in jointlist:
        #PoseX[jointindex]=updateArray(deleterror(searcherror(PoseX[jointindex]), PoseX[jointindex]))
        #PoseY[jointindex] = updateArray(deleterror(searcherror(PoseY[jointindex]), PoseY[jointindex]))
        newPoseX.append(PoseX[jointindex])
        newPoseY.append(PoseY[jointindex])
    return computedistancestd(np.array(newPoseX),np.array(newPoseY))

def sumerror(Array):
    #sum=0
    Sum=0
    for i_1 in range(1,len(Array),2):
        #print('i:',i_1)
        sum=Array[i_1]-Array[i_1-1]
        Sum=Sum+sum
    return Sum

def deletezero(Array):
    newArray=[]
    for array in Array:
        if array!=0:
            newArray.append(array)
    return newArray
def computedistance(X,Y):
    inDistanceList=[]
    for i_1 in range(0,len(X[0])-1):
        innerdistance=0
        for j_1 in range(0,len(X[:,])):
            #print('length:',len(X[:,]))
            distance=math.sqrt(math.pow((X[j_1,i_1]-X[j_1,i_1+1]),2)+math.pow((Y[j_1,i_1]-Y[j_1,i_1+1]),2))
            #print('distance:',distance)
            innerdistance=innerdistance+distance
        inDistanceList.append(innerdistance)
    return np.mean(inDistanceList)

def zeorexist(Array):
    Zero=1
    for i_exist in range(0,25):
        if sum(Array[i_exist])==0:
           Zero=0
    return Zero
def multi(N):
    result=1
    for n in N:
        result=result*n
    return result


def computedistancestd(X,Y):
    inDistanceList=[]
    for i_1 in range(0,len(X[0])-1):
        innerdistance=0
        for j_1 in range(0,len(X[:,])):
            distance=math.sqrt(math.pow((X[j_1,i_1]-X[j_1,i_1+1]),2)+math.pow((Y[j_1,i_1]-Y[j_1,i_1+1]),2))
            innerdistance=innerdistance+distance
        inDistanceList.append(innerdistance)
    return np.std(inDistanceList,ddof=1)

def updateArray(Prearray):
    Newarray=[]
    ma=MovAvg()
    for prearray in Prearray:
        Newarray.append(ma.update(prearray))
    #print('updateArray:',len(Newarray))
    return Newarray

def searcherror(Array):
    newArray=[]
    for i_1 in range(1,len(Array)):
        if abs(Array[i_1-1]-Array[i_1])>30:
            newArray.append(i_1-1)
    #print('newArray:',newArray)
    #print('error length:',len(newArray))
    return newArray

def deleterror(index,Array):
    begin=[]
    end=[]
    newArray=[]
    for i_1 in range(0,len(index)):
        if i_1%2!=0:
            begin.append(index[i_1-1])
            end.append(index[i_1])
    newArray=Array
    for i_2 in range(0,len(begin)):
        be=begin[i_2]
        en=end[i_2]
        for j_1 in range(be+1,en+1):
            #newArray[j_1] = 0
            newArray[j_1]=newArray[be]
    #print('deleteerror:',newArray)
    #return deletezero(newArray)
    return newArray

def str2sec(x):
    h, m, s = x.strip().split(':')
    return (int(h) * 3600 + int(m) * 60 + int(s)) * 30


def dict_generator(indict, pre=None):
    pre = pre[:] if pre else []
    if isinstance(indict, dict):
        for key, value in indict.items():
            if isinstance(value, dict):
                if len(value) == 0:
                    yield pre + [key, '{}']
                else:
                    for d in dict_generator(value, pre + [key]):
                        yield d
            elif isinstance(value, list):
                if len(value) == 0:
                    yield pre + [key, '[]']
                else:
                    for v in value:
                        for d in dict_generator(v, pre + [key]):
                            yield d
            elif isinstance(value, tuple):
                if len(value) == 0:
                    yield pre + [key, '()']
                else:
                    for v in value:
                        for d in dict_generator(v, pre + [key]):
                            yield d
            else:
                yield pre + [key, value]
    else:
        yield indict

def get_file_path(root_path, file_list, dir_list):
    dir_or_files = os.listdir(root_path)
    for dir_file in dir_or_files:

        dir_file_path = os.path.join(root_path, dir_file)

        if os.path.isdir(dir_file_path):
            dir_list.append(dir_file_path)

        else:
            file_list.append(dir_file_path)

def countdistance(pre,next):
    Distance=0
    for i in range(0,4):
        #print('前一时刻第',i,'个点的坐标：','(',pre[i,0],',',pre[i,1],')')
        #print('后一时刻第', i, '个点的坐标：', '(', next[i, 0], ',', next[i,1], ')')
        distance=math.sqrt(math.pow((pre[i,0]-next[i,0]),2)+math.pow((pre[i,1]-next[i,1]),2))
        Distance=Distance+distance
    return Distance

def getclip(mp4_list):
    clip_list=[]
    for mp4 in mp4_list:
        clip_list.append(int(mp4[-6:-4]))
    #clip_list.sort()
    return clip_list

point_path = r"/mnt/data1/zhanghongyi/origin_CS_PR/PR/"
point_file_list=[]
point_dir_list=[]
get_file_path(point_path, point_file_list, point_dir_list)
point_dir_list.sort()
point_file_list.sort()
Raw_x = []
Raw_y = []
for point_file in point_file_list:
    if 'json' not in point_file or 'correct' in point_file:
        continue
    print('point_file:',point_file)
    json_result={}
    Value = json.load(open(point_file))
    #print('shape:',np.array(jsonpath(Value, "$..data")).shape)
    pose = np.array(jsonpath(Value, "$..data")).reshape(300,25,3)
    #print('pose:',pose)
    Raw_x = []
    Raw_y = []
    Raw_c=[]
    for i in range(0,300):
        changejointupper(np.array(pose)[i], [2,3,4,5,6,7,9,10,11,12,13, 14,15,16,17,18])
        changejointlower(np.array(pose)[i], [19,20,21,22,23,24])
        Raw_x.append(np.array(pose)[i][:, 0])
        Raw_y.append(np.array(pose)[i][:, 1])
        Raw_c.append(np.array(pose)[i][:, 2])

    #print('Raw_x:',np.array(Raw_x).shape)
    #print('Raw_y:',np.array(Raw_y).shape)
    #print('Raw_c:',np.array(Raw_c).shape)
    my_Raw_x=[]
    my_Raw_y=[]
    my_Raw_c=np.array(Raw_c)

    for j in range(0,25):
        #print('pre x:',np.array(Raw_x)[:,j])
        #fig, axes = plt.subplots(2, 2)
        #ax1 = axes[0, 0]
        #ax2 = axes[0, 1]
        #print('error length x:',sumerror(searcherror(np.array(Raw_x)[:,j])))
        #print('error length y:', sumerror(searcherror(np.array(Raw_y)[:,j])))


        #if sumerror(searcherror(np.array(Raw_x)[:,j]))<70 and sumerror(searcherror(np.array(Raw_y)[:,j]))<70:
        my_Raw_x.append(updateArray(deleterror(searcherror(np.array(Raw_x)[:, j]), np.array(Raw_x)[:, j])))
        my_Raw_y.append(updateArray(deleterror(searcherror(np.array(Raw_y)[:, j]), np.array(Raw_y)[:, j])))
        #else:
         #   my_Raw_x.append(np.zeros(300))
          #  my_Raw_y.append(np.zeros(300))
        #print('shape:',updateArray(deleterror(searcherror(np.array(Raw_x)[:,j]), np.array(Raw_x)[:,j])))

        #ax1.plot(np.array(Raw_x)[:,j], label='raw_r_wrist_x')
        #ax1.plot(updateArray(deleterror(searcherror(np.array(Raw_x)[:,j]), np.array(Raw_x)[:,j])), label='new_raw_r_wrist_x')
        #ax1.plot(deleterror(searcherror(np.array(Raw_x)[:, j]), np.array(Raw_x)[:, j]),label='new_raw_r_wrist_x')

        #print('after x:',updateArray(deleterror(searcherror(np.array(Raw_x)[:,j]), np.array(Raw_x)[:,j])))
        #print('pre y:', np.array(Raw_y)[:, j])

        #print('after y:',updateArray(deleterror(searcherror(np.array(Raw_y)[:, j]), np.array(Raw_y)[:, j])))
        #ax2.plot(np.array(Raw_y)[:,j], label='raw_r_wrist_x')
        #ax2.plot(updateArray(deleterror(searcherror(np.array(Raw_y)[:, j]), np.array(Raw_y)[:, j])),label='new_raw_r_wrist_y')
        #plt.legend()
        #titlename='the'+str(j)+'joints'+' error:'+str(sumerror(searcherror(np.array(Raw_x)[:,j])))
        #plt.title(titlename)
        #plt.show()
        #plt.close()
    #print('shape:',np.array(my_Raw_x).shape)
    #print('zerox:',zeorexist(np.array(my_Raw_x)))
    #print('zeroy:', zeorexist(np.array(my_Raw_y)))
    #if zeorexist(np.array(my_Raw_x))==0 or zeorexist(np.array(my_Raw_y))==0:
        #new_Raw=np.zeros((300,3,25,1))
        #print('new_Raw',new_Raw)
    #else:
    new_my_Raw_x=np.transpose(np.array(my_Raw_x))
    new_my_Raw_y = np.transpose(np.array(my_Raw_y))
    #print('my_Raw_x.shape:',np.array(my_Raw_x))
    #print('my_Raw_y.shape:', np.array(my_Raw_y))
    new_Raw_x=np.expand_dims(np.array(new_my_Raw_x),2)
    new_Raw_y = np.expand_dims(np.array(new_my_Raw_y), 2)
    new_Raw_c = np.expand_dims(np.array(my_Raw_c), 2)
    new_Raw=np.hstack((new_Raw_x,new_Raw_y,new_Raw_c)).reshape(300,3,25,1)
    New=[]

    for k in range(0,300):
        #print('shape:',new_Raw[k].shape)
        #print('array:', new_Raw[k])
        #print('array[0]:',new_Raw[k][0])
        #print('array[1]:',new_Raw[k][1])
        #print('array[2]:',new_Raw[k][2])
        new=np.hstack((new_Raw[k][0],new_Raw[k][1],new_Raw[k][2]))
        #print('new:',new)
        New.append(new)

    #print('New:',sum(sum(sum(np.array(New)))))
    #print('New.shape:',np.array(New).shape)
    #print('new Raw:', np.array(new_Raw).shape)
    '''
    print('new Raw_x:',np.array(new_Raw_x).shape)
    print('new Raw_x:',np.array(new_Raw_x))
    print('new Raw_y:', np.array(new_Raw_y).shape)
    print('new Raw_y:', np.array(new_Raw_y))
    print('new Raw_c:',np.array(new_Raw_c).shape)
    print('new Raw_c:', np.array(new_Raw_c))
    print('new Raw:',np.array(new_Raw).shape)
    print('new Raw:',np.array(new_Raw))
    '''
    if sum(sum(sum(np.array(New))))>0:
        distance = selectjointdistance(np.array(my_Raw_x),np.array(my_Raw_y), [4,7,11,14,20,23])
        #distance=selectjointdistance(np.transpose(np.array(my_Raw_x)),np.transpose(np.array(my_Raw_y)),[11,14])
        print('distance:',distance)
        if distance>3 and distance<10:
            json_result['category'] = 'PR'
            json_result['data'] = np.expand_dims(New, axis=3).tolist()  # 300 * 25 * 3 * 1
            json_result['distance']=distance
            with open(point_file[:-5] + '_correct.json', 'w') as f2:
                json.dump(json_result, f2)








