import cv2
import numpy as np
import matplotlib.pyplot as plt

import imageio

from PIL import Image
import os
from pathlib import Path
import json
import csv
from jsonpath import jsonpath
import math
import cv2
import imageio
#滤波操作
class MovAvg(object):
    def __init__(self, window_size=5):
        self.window_size = window_size
        self.data_queue = []
    def update(self, data):
        if len(self.data_queue) == self.window_size:
            del self.data_queue[0]
        #if data>0:
        self.data_queue.append(data)
        return sum(self.data_queue)/len(self.data_queue)

def changejoint(pose,jointlist):
    for jointindex in jointlist:
        if (jointindex+3) not in jointlist:
            continue
        if pose[jointindex,0]>pose[jointindex+3,0]:
            pose[jointindex, 0],pose[jointindex + 3, 0]=pose[jointindex + 3, 0],pose[jointindex, 0]
            pose[jointindex, 1], pose[jointindex + 3, 1] = pose[jointindex + 3, 1], pose[jointindex, 1]

def selectjointdistance(PoseX,PoseY,jointlist):
    newPoseX=[]
    newPoseY=[]
    for jointindex in jointlist:
        PoseX[jointindex]=updateArray(deleterror(searcherror(PoseX[jointindex]), PoseX[jointindex]))
        PoseY[jointindex] = updateArray(deleterror(searcherror(PoseY[jointindex]), PoseY[jointindex]))
        newPoseX.append(PoseX[jointindex])
        newPoseY.append(PoseY[jointindex])
    return computedistance(np.array(newPoseX),np.array(newPoseY))

def selectjointdistancestd(PoseX,PoseY,jointlist):
    newPoseX=[]
    newPoseY=[]
    for jointindex in jointlist:
        PoseX[jointindex]=updateArray(deleterror(searcherror(PoseX[jointindex]), PoseX[jointindex]))
        PoseY[jointindex] = updateArray(deleterror(searcherror(PoseY[jointindex]), PoseY[jointindex]))
        newPoseX.append(PoseX[jointindex])
        newPoseY.append(PoseY[jointindex])
    return computedistancestd(np.array(newPoseX),np.array(newPoseY))

def deletezero(Array):
    newArray=[]
    for array in Array:
        if array!=0:
            newArray.append(array)
    return newArray
def computedistance(X,Y):
    inDistanceList=[]
    for i_1 in range(0,len(X[0])-1):
        innerdistance=0
        for j_1 in range(0,len(X[:,])):
            distance=math.sqrt(math.pow((X[j_1,i_1]-X[j_1,i_1+1]),2)+math.pow((Y[j_1,i_1]-Y[j_1,i_1+1]),2))
            #print('distance:',distance)
            innerdistance=innerdistance+distance
        inDistanceList.append(innerdistance)
    return np.mean(inDistanceList)

def multi(N):
    result=1
    for n in N:
        result=result*n
    return result


def computedistancestd(X,Y):
    inDistanceList=[]
    for i_1 in range(0,len(X[0])-1):
        innerdistance=0
        for j_1 in range(0,len(X[:,])):
            distance=math.sqrt(math.pow((X[j_1,i_1]-X[j_1,i_1+1]),2)+math.pow((Y[j_1,i_1]-Y[j_1,i_1+1]),2))
            innerdistance=innerdistance+distance
        inDistanceList.append(innerdistance)
    return np.std(inDistanceList,ddof=1)

def updateArray(Prearray):
    Newarray=[]
    ma=MovAvg()
    for prearray in Prearray:
        Newarray.append(ma.update(prearray))
    return Newarray

def searcherror(Array):
    newArray=[]
    for i_1 in range(1,len(Array)):
        if abs(Array[i_1-1]-Array[i_1])>30:
            newArray.append(i_1-1)
    return newArray

def deleterror(index,Array):
    begin=[]
    end=[]
    newArray=[]
    for i_1 in range(0,len(index)):
        if i_1%2!=0:
            begin.append(index[i_1-1])
            end.append(index[i_1])

    for i_2 in range(0,len(begin)):
        be=begin[i_2]
        en=end[i_2]
        for j_1 in range(be+1,en+1):
            Array[j_1]=Array[be]
    return Array

def str2sec(x):
    h, m, s = x.strip().split(':')
    return (int(h) * 3600 + int(m) * 60 + int(s)) * 30


def dict_generator(indict, pre=None):
    pre = pre[:] if pre else []
    if isinstance(indict, dict):
        for key, value in indict.items():
            if isinstance(value, dict):
                if len(value) == 0:
                    yield pre + [key, '{}']
                else:
                    for d in dict_generator(value, pre + [key]):
                        yield d
            elif isinstance(value, list):
                if len(value) == 0:
                    yield pre + [key, '[]']
                else:
                    for v in value:
                        for d in dict_generator(v, pre + [key]):
                            yield d
            elif isinstance(value, tuple):
                if len(value) == 0:
                    yield pre + [key, '()']
                else:
                    for v in value:
                        for d in dict_generator(v, pre + [key]):
                            yield d
            else:
                yield pre + [key, value]
    else:
        yield indict

def get_file_path(root_path, file_list, dir_list):
    dir_or_files = os.listdir(root_path)
    for dir_file in dir_or_files:

        dir_file_path = os.path.join(root_path, dir_file)

        if os.path.isdir(dir_file_path):
            dir_list.append(dir_file_path)

        else:
            file_list.append(dir_file_path)

def countdistance(pre,next):
    Distance=0
    for i in range(0,4):
        #print('前一时刻第',i,'个点的坐标：','(',pre[i,0],',',pre[i,1],')')
        #print('后一时刻第', i, '个点的坐标：', '(', next[i, 0], ',', next[i,1], ')')
        distance=math.sqrt(math.pow((pre[i,0]-next[i,0]),2)+math.pow((pre[i,1]-next[i,1]),2))
        Distance=Distance+distance
    return Distance

def getclip(mp4_list):
    clip_list=[]
    for mp4 in mp4_list:
        clip_list.append(int(mp4[-6:-4]))
    #clip_list.sort()
    return clip_list


point_path = r"/mnt/data1/zhanghongyi/non_normlize_CS_PR/CS/"
point_file_list=[]
point_dir_list=[]
get_file_path(point_path, point_file_list, point_dir_list)
point_dir_list.sort()
point_file_list.sort()
for point_file in point_file_list:
    print('point_file:',point_file)
    Value = json.load(open(point_file))
    firstpose = jsonpath(Value, "$..data")[0][0:150]
    secondpose = jsonpath(Value, "$..data")[0][150:300]
    Raw_x_first=[]
    Raw_y_first = []
    Raw_x_second = []
    Raw_y_second = []


    #print('pose:',np.array(firstpose).shape)
    #print('pose:',np.array(secondpose).shape)
    for i in range(0,150):
        changejoint(np.array(firstpose)[i],[11,14])
        Raw_x_first.append(np.array(firstpose)[i][:,0])
        Raw_y_first.append(np.array(firstpose)[i][:, 1])
    firstDistance = selectjointdistance(np.transpose(np.array(Raw_x_first)), np.transpose(np.array(Raw_y_first)), [11,14])
    print('firstDistance:',firstDistance)
    for i in range(0,150):
        changejoint(np.array(secondpose)[i],[11,14])
        Raw_x_second.append(np.array(secondpose)[i][:, 0])
        Raw_y_second.append(np.array(secondpose)[i][:, 1])
    secondDistance = selectjointdistance(np.transpose(np.array(Raw_x_second)), np.transpose(np.array(Raw_y_second)), [11,14])
    print('secondDistance:',secondDistance)

