%function:Calculate the error of the nearest spot check
% - Params：
%   - A: Initial sparse point cloud [n,3]
%   - B: Target model point cloud [m,3]
%   - Mdl: kdtree model of B
% - Return：
%   - cost:the error(Distance sum)
function cost = calculateCost( A, B, Mdl)

idx = knnsearch(Mdl,A);
NN = B(idx,:);
cost = sum(sqrt(sum((NN-A).^2,2)))/length(A);

end
