%function:Randomly transform the input matrix to generate test data
% - Params：
%   - A:sparse point cloud [n,3]
% - Return：
%   - B:the transformed test point cloud [n,3]
%   - R:Real rotation matrix [3,3]
%   - T:Real translation matrix [1,3]
function [ B,R,T ] = randtrans( A )

%1.Generate random rotation angles
theta = (2*rand-1)*60*pi/180; %rotation about z
gamma = (2*rand-1)*60*pi/180; %rotation about y
alpha = (2*rand-1)*60*pi/180; %rotation about x
%2.Calculate rotation matrix (right-hand coordinate system)
Rz = [cos(theta), -sin(theta), 0; sin(theta), cos(theta), 0; 0,0,1];
Ry = [cos(gamma), 0, sin(gamma); 0,1,0; -sin(gamma), 0, cos(gamma)];
Rx = [1,0,0; 0, cos(alpha), -sin(alpha); 0, sin(alpha), cos(alpha)];
R = Rz*Ry*Rx;
%3.Generate random translation
[~, dim] = size(A);
T = randi([-1,1],1,dim);
%5.Generate the final transformed coordinate B under the transformation matrix
B = transform(A,R,T);

end
