%Function to transform matrix B
% - Params：
%   - B:point cloud [n,3]
%   - R:Rotation transformation [3,3]
%   - T:Translation transformation [1,3]
% - Return：
%   - B:Transform point cloud [n,3]
function [ B ] = transform( B,R,T )

[num, dim] = size(B);
%2-dim
if dim == 2
    B = [cos(-R), sin(-R); -sin(-R), cos(-R)]*B'-repmat(T',1,num);
    B = B';
end
%3-dim
if dim == 3
    B = R*B' + repmat(T',1,num);
    B = B';

end
