package com.eagle.vector.dao.impl;

import com.eagle.vector.dao.RedisDao;
import com.eagle.vector.pojo.UserVector;
import org.apache.hadoop.hbase.util.Bytes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

@Repository
public class RedisDaoImpl implements RedisDao {

    @Autowired
    RedisConnectionFactory redisConnectionFactory;

    @Override
    public UserVector getUserVector(String user_id) {
        UserVector userVector = new UserVector();
        List<String> vector = new ArrayList<String>();
        RedisConnection redisConnection = redisConnectionFactory.getConnection();
        if(redisConnection.lRange(Bytes.toBytes(user_id), 0, 15).size() != 0) {
            List<byte[]> bytes =  redisConnection.lRange(Bytes.toBytes(user_id), 0, 15);
            for(byte[] bt:bytes) {
                vector.add(Bytes.toString(bt));
            }
            userVector.set_hit(true);
        } else {
            Random r = new Random();
            for(int i = 0; i < 16; i++) {
                Double d = r.nextGaussian();
                vector.add(d.toString());
            }
            userVector.set_hit(false);
        }
        redisConnection.close();
        userVector.setVector(vector.toString());
        return userVector;
    }
}
