#python -m visdom.server
import time
from options.train_options import TrainOptions
from data.data_loader import CreateDataLoader
from models import create_model


import torch
import torchvision

if __name__ == "__main__":
    ############################
    '''
    model = torchvision.models.resnet101(pretrained=True)
    example = torch.rand(1, 3, 224, 224)
    traced_script_module = torch.jit.trace(model, example)
    output = traced_script_module(torch.ones(1, 3, 224, 224))
    print(type(output), output[0, :10], output.shape)
    traced_script_module.save("traced_resnet_model1.5.0.pt")
    '''

    ##############################
    opt = TrainOptions().parse()
    data_loader = CreateDataLoader(opt)
    dataset = data_loader.load_data()
    dataset_size = len(data_loader)
    print('#training images = %d' % dataset_size)

    model = create_model(opt)

    total_steps = 0

    for epoch in range(opt.epoch_count, opt.niter + opt.niter_decay + 1):
        epoch_start_time = time.time()
        iter_data_time = time.time()
        epoch_iter = 0

        for i, data in enumerate(dataset):

            A_path = data['A_paths']
            A = data['A'][0]
            B = data['B'][0]
            mask = data['M'][0]
            A_flip = data['A_F'][0]
            B_flip = data['B_F'][0]
            for j in range(A.shape[0]):
                data_temp = {'A': A[j].unsqueeze(0), 'B': B[j].unsqueeze(0), 'A_F': A_flip[j].unsqueeze(0),
                             'B_F': B_flip[j].unsqueeze(0), 'M': mask[j].unsqueeze(0),
                             'A_paths': A_path}

                iter_start_time = time.time()
                if total_steps % opt.print_freq == 0:
                    t_data = iter_start_time - iter_data_time

                total_steps += opt.batchSize
                epoch_iter += opt.batchSize

                model.set_input(data_temp) # it not only sets the input data with mask, but also sets the latent mask.

                # Additonal, should set it before 'optimize_parameters()'.
                if total_steps % opt.display_freq == 0:
                    if opt.show_flow:
                        model.set_show_map_true()

                model.optimize_parameters()

                if total_steps % opt.display_freq == 0:
                    save_result = total_steps % opt.update_html_freq == 0
                    if opt.show_flow:
                        model.set_flow_src()
                        model.set_show_map_false()


                if total_steps % opt.print_freq == 0:
                    losses = model.get_current_losses()
                    t = (time.time() - iter_start_time) / opt.batchSize

                if total_steps % opt.save_latest_freq == 0:
                    print('saving the latest model (epoch %d, total_steps %d)' %
                            (epoch, total_steps))
                    model.save_networks('latest')

                iter_data_time = time.time()
        if epoch % opt.save_epoch_freq == 0:
            print('saving the model at the end of epoch %d, iters %d' %
                    (epoch, total_steps))
            model.save_networks('latest')
            if not opt.only_lastest:
                model.save_networks(epoch)

        print('End of epoch %d / %d \t Time Taken: %d sec' %
                (epoch, opt.niter + opt.niter_decay, time.time() - epoch_start_time))
        model.update_learning_rate()
