#include<opencv2\opencv.hpp>
#include "Global_variable.h"
using namespace cv;
using namespace std;
double distance(Point2d a, Point2d b)
{
	return sqrtf((powf((a.x - b.x), 2)) + powf((a.y - b.y), 2));
}
void KeyPointsToPoints(vector<KeyPoint> kpts, vector<Point2d> &pts, int minx, int miny)
{
	for (int i = 0; i < kpts.size(); i++) {
		kpts[i].pt.x += minx;
		kpts[i].pt.y += miny;
		pts.push_back(kpts[i].pt);
	}
}
double CosSimi(vector<double>cr1, vector<double>cr2)
{
	double sum1 = 0, sum2 = 0, mul = 0;
	for (int i = 0; i < cr1.size(); i++)
	{
		sum1 += cr1[i] * cr1[i];
		sum2 += cr2[i] * cr2[i];
		mul += cr1[i] * cr2[i];
	}
	double fm = pow(sum1 * sum2,0.5);

	return mul / fm;
}
class EleCTag
{
public:
	vector<Point> corner;
	vector<Point2d> wccenter;
	vector<Point2d> bccenter;
	vector<double> cr;
};
void sortCornerWCenter(EleCTag &ECTag, int midx, int midy)//Բͽǵ˳
{
	//cout << midx << endl;
	//cout << midy << endl;
	double vectmp1[2] = { ECTag.corner[2].x - ECTag.corner[1].x, ECTag.corner[2].y - ECTag.corner[1].y };
	double vectmp2[2] = { ECTag.corner[1].x - ECTag.corner[0].x, ECTag.corner[1].y - ECTag.corner[0].y };
	double t = vectmp1[0] * vectmp2[1] - vectmp1[1] * vectmp2[0];//
	if (t > 0)//ʱΪ˳ʱ
	{
		int tmpcornerx = ECTag.corner[1].x;
		int tmpcornery = ECTag.corner[1].y;
		ECTag.corner[1].x = ECTag.corner[3].x;
		ECTag.corner[1].y = ECTag.corner[3].y;
		ECTag.corner[3].x = tmpcornerx;
		ECTag.corner[3].y = tmpcornery;
	}
	int minCornerNum = 0;
	double minSum = DBL_MAX;
	double Sum = 0;
	for (int i = 0; i < 4; i++)//ͨԲҵ0Žǵ
	{
		for (int j = 0; j < 7; j++)
		{
			double tmpdis = distance(ECTag.corner[i], ECTag.wccenter[j]);
			Sum += tmpdis;
		}
		if (Sum < minSum)
		{
			minSum = Sum;
			minCornerNum = i;
		}
		Sum = 0;
	}
	if (minCornerNum != 0)
	{
		for (int i = 0; i != minCornerNum; i++)
		{
			ECTag.corner.push_back(ECTag.corner[i]);
		}
		ECTag.corner.erase(ECTag.corner.begin(), ECTag.corner.begin() + minCornerNum);
	}
	sort(ECTag.wccenter.begin(), ECTag.wccenter.end(), [&ECTag](auto a, auto  b)//ԲID
	{
		if (distance(a, ECTag.corner[0]) + distance(a, ECTag.corner[1]) < distance(b, ECTag.corner[0]) + distance(b, ECTag.corner[1]))
			return true;
	});
	sort(ECTag.wccenter.begin(), ECTag.wccenter.begin() + 4, [&ECTag](auto  a, auto  b)
	{
		if (distance(a, ECTag.corner[0]) < distance(b, ECTag.corner[0]))
			return true;
	});
	//cout << "ECTag.wccenter:" << ECTag.wccenter << endl;
}
void sortBCenter(EleCTag &ECTag)
{
	sort(ECTag.bccenter.begin(), ECTag.bccenter.end(), [&ECTag](auto a, auto  b)//ԲID
	{
		if (distance(a, ECTag.wccenter[0]) < distance(b, ECTag.wccenter[0]))
			return true;
	});
	sort(ECTag.bccenter.begin() + 1, ECTag.bccenter.begin() + 3, [&ECTag](auto a, auto  b)//ԲID
	{
		if (distance(a, ECTag.wccenter[3]) < distance(b, ECTag.wccenter[3]))
			return true;
	});
	//cout << "ECTag.bccenter:" << ECTag.bccenter << endl;
}
double c2ST(Point2d a, Point2d b, Point2d c)//2
{
	double s = a.x*b.y + b.x*c.y + c.x*a.y - a.x*c.y - b.x*a.y - c.x*b.y;
	return s;
}
void countCR(EleCTag &ECTag)//㽻
{
	ECTag.cr.clear();
	//cout << "================================" << endl;
	for (int i = 0; i < 7; i++)
	{
		double st1 = c2ST(ECTag.wccenter[i], ECTag.bccenter[0], ECTag.bccenter[1]);
		double st2 = c2ST(ECTag.wccenter[i], ECTag.bccenter[2], ECTag.bccenter[3]);
		double st3 = c2ST(ECTag.wccenter[i], ECTag.bccenter[0], ECTag.bccenter[2]);
		double st4 = c2ST(ECTag.wccenter[i], ECTag.bccenter[1], ECTag.bccenter[3]);
		double cr1 = st1 * st2 / st3 / st4;
		//cout << "" << cr1 << ",";
		ECTag.cr.push_back(cr1);
	}
	
}
void EleCTag_detector(Mat img)
{
	//string imgpath = "F:/11cTag/phone.bmp";
	//Mat img = imread(imgpath, 0);
	const clock_t begin_time = clock();
	Mat img2,local;
	adaptiveThreshold(img, img2, 255, cv::ADAPTIVE_THRESH_MEAN_C, cv::THRESH_BINARY, 51, 11);
	GaussianBlur(img2, local, Size(3, 3), 0);
	float seconds = float(clock() - begin_time);
	//cout << "adaptiveThreshold:" << seconds << endl;
	vector<vector<Point>> contours;
	vector<Vec4i> hierarchy;
	findContours(local, contours, hierarchy, RETR_TREE, CHAIN_APPROX_SIMPLE, Point());
	seconds = float(clock() - begin_time);
	//cout << "findContours:" << seconds << endl;
	//cout << hierarchy[0] << endl;
	Mat imageContours = Mat::zeros(local.size(), CV_8UC1);
	Mat Contours = Mat::zeros(local.size(), CV_8UC1);  // 
	Mat dstImg = Mat::zeros(local.size(), CV_8UC1);  // 
	vector<vector<Point>> contours_poly(contours.size());//ڴߵ㼯
	vector<vector<Point>> potential_quad;
	for (int i = 0; i < contours.size(); i++)
	{
		//contours[i]ǵicontours[i].size()ǵiеص  
		//for (int j = 0; j < contours[i].size(); j++)
		//{
			//Ƴcontoursеص  
			//Point P = Point(contours[i][j].x, contours[i][j].y);
			//Contours.at<uchar>(P) = 255;
		//}

		approxPolyDP(Mat(contours[i]), contours_poly[i], arcLength(Mat(contours[i]), true)*0.02, true);
		//αĸ,͹ģ
		if (contours_poly[i].size() == 4 && fabs(contourArea(Mat(contours_poly[i]))) > 1000 && isContourConvex(Mat(contours_poly[i])))
		{
			//cout << contours_poly[i] << endl;
			//potential_quad.push_back(contours_poly[i]);
			drawContours(dstImg, contours_poly, i, Scalar(255), 1, 8);  //
			Mat imgtmp = img.clone();
			int maxx = 0, maxy = 0, minx = INT_MAX, miny = INT_MAX;
			for (int j = 0; j < 4; j++)
			{
				maxx = (max)(contours_poly[i][j].x, maxx);
				maxy = (max)(contours_poly[i][j].y, maxy);
				minx = (min)(contours_poly[i][j].x, minx);
				miny = (min)(contours_poly[i][j].y, miny);
			}
			int xlen = maxx - minx;
			int ylen = maxy - miny ;
			Rect rect(minx, miny, xlen, ylen);
			Mat roi = Mat(imgtmp, rect);
			Mat local_roi= Mat(local, rect);
			Mat showroi = roi.clone();
			SimpleBlobDetector::Params params;//ɫԲ
			//imshow("ROI2", showroi);
			//waitKey(0);
			//imshow("local_roi", local_roi);
			//waitKey(0);
			params.filterByColor = true;
			params.blobColor = 255;
			params.filterByCircularity = true;    //ߵԲȵƱ
			params.minCircularity = 0.2f;    //ߵСԲ 
			params.filterByArea = true;
			params.maxArea = xlen * ylen / 10;
			params.minConvexity = 0.8f;

			//cout << "params.maxArea:" << params.maxArea << endl;
			cv::Ptr<cv::SimpleBlobDetector> detector = SimpleBlobDetector::create(params);
			vector<KeyPoint> keyp;
			detector->detect(roi, keyp);
			//cout <<"keyp.size():"<< keyp.size() << endl;
			if (keyp.size() == 7) //7ɫԲ
			{
				int midx = (maxx + minx) / 2;
				int midy = (maxy + miny) / 2;
				EleCTag ECTag;
				ECTag.corner = contours_poly[i];
				KeyPointsToPoints(keyp, ECTag.wccenter, minx, miny);
				//const clock_t begin_time = clock();
				sortCornerWCenter(ECTag, midx, midy);
				//float seconds = float(clock() - begin_time);
				//cout << "ECTag.wccenter:" << ECTag.wccenter << endl;
				//cout << "seconds:"<<seconds << endl;
				SimpleBlobDetector::Params params2;//ڲɫԲ
				params2.blobColor = 0;
				params2.filterByCircularity = true;
				params2.minCircularity = 0.2f;
				params2.minConvexity = 0.8f;
				cv::Ptr<cv::SimpleBlobDetector> detector2 = SimpleBlobDetector::create(params2);
				vector<KeyPoint> keyp2;
				detector2->detect(roi, keyp2);
				KeyPointsToPoints(keyp2, ECTag.bccenter, minx, miny);
				sortBCenter(ECTag);
				//cout << "keyp2.size:" << keyp2.size() << endl;
				countCR(ECTag);
				for (int k = 0; k < Global_variable::TagCR.rows; k++)
				{
					double simi = CosSimi(ECTag.cr, Global_variable::TagCR.row(k));
					//cout << "simi:" << simi << endl;
				}
				//imshow("ROI", roi);
				//waitKey(0);
			}
		}

		//drawContours(imageContours, contours, i, Scalar(255), 1, 8, hierarchy);
	}
	//seconds = float(clock() - begin_time);
	//cout << "others:" << seconds << endl;
	//cv::namedWindow("approx", 0);
	//imshow("approx", dstImg);
	//imshow("Contours Image", imageContours); //  
	//imshow("Point of Contours", Contours);   //contoursڱ㼯  
	//imshow("imgraw", local);

	//waitKey(0);
}

