import time

import openpyxl

from openpyxl.styles import PatternFill, Alignment
from split_wav import *


def create_sheet(path, sheet_name, value):
    """
        根据给定的表头，初始化表格，
        :param path: str, 表格(book)的存储位置
        :param sheet_name: str, 表(sheet)的名字
        :param value: list, 表头内容为['起始时间','终止时间','字幕','建议','旁边解说脚本']
        :return: None
    """
    index = len(value)
    workbook = openpyxl.Workbook()
    sheet = workbook.active
    sheet.title = sheet_name
    # 将字幕对应的那一列扩宽一些
    sheet.column_dimensions['C'].width = 50
    for i in range(0, index):
        for j in range(0, len(value[i])):
            sheet.cell(row=i + 1, column=j + 1, value=str(value[i][j]))
    workbook.save(path)


def write_to_sheet(path, sheet_name, value):
    """
    向已存在的表格中写入数据
    :param path:
    :param sheet_name:
    :param value:
    :return:
    """
    index = len(value)
    workbook = openpyxl.load_workbook(path)
    sheet = workbook.get_sheet_by_name(sheet_name)
    cur_row = sheet.max_row
    for i in range(0, index):
        for j in range(0, len(value[i])):
            sheet.cell(row=cur_row + i + 1, column=j + 1, value=str(value[i][j]))
            if value[i][j] == '' or value[i][j] == '插入旁白':
                sheet.cell(row=cur_row + i + 1, column=j + 1).fill = PatternFill(fill_type='solid', fgColor='ffff00')
            if j == 2:
                sheet.cell(row=cur_row + i + 1, column=j + 1).alignment = Alignment(wrapText=True)
    workbook.save(path)


def trans_to_mono(wav_path):
    """
    将音频的通道数channel转换为1
    :param wav_path: str, 需要转换的音频地址
    :return: new_wav_path: str, 转换后得到的新音频地址
    """
    new_wav_path = wav_path[:-4] + "_1.wav"
    command = 'ffmpeg -i {} -ac 1 -y {}'.format(wav_path, new_wav_path)
    os.system(command)
    return new_wav_path


def concat_wav(root):
    txt_path = os.path.join(root, 'list.txt')
    with open(txt_path, 'w', encoding='utf-8') as f:
        for file_name in os.listdir(root):
            if os.path.isdir(os.path.join(root, file_name)):
                wav_path = os.path.join(root, file_name) + "/vocal.wav"
                f.write("file \'" + wav_path + "\'\n")
    output_file = os.path.join(root, 'total.wav')
    command = 'ffmpeg -f concat -safe 0 -i {} -y {}'.format(txt_path, output_file)
    os.system(command)
    return output_file


def detect_with_asr(video_path, book_path, start_time=0, end_time=-1, state=None):
    # 临时存储各种中间产物的文件夹
    tmp_root = './tmp'
    if not os.path.exists(tmp_root):
        os.mkdir(tmp_root)

    if not os.path.exists(video_path):
        print("你输入的视频地址有误，请仔细检查一下")
        return
    # 提取出视频中的音频，分割后提取出其中的人声部分并存储
    audio_path = extract_audio(video_path, tmp_root, start_time, end_time)
    # root = split_audio()
    # extrac_speech()
    #
    # # 将提取出的人声拼接，并将音频的channel调整为1
    # total_wav_path = concat_wav(root)
    # audio_path = trans_to_mono(total_wav_path)

    # xlsx中的表格名为“旁白插入位置建议”
    book_name_xlsx = book_path
    sheet_name_xlsx = "旁白插入位置建议"

    # 如果当前路径下不存在与视频同名的表格，则创建输出内容存放的表格
    if not os.path.exists(book_name_xlsx):
        table_head = [["起始时间", "终止时间", "字幕", '建议', '解说脚本']]
        create_sheet(book_name_xlsx, sheet_name_xlsx, table_head)

    sys.path.append("./PaddlePaddle_DeepSpeech2")
    from infer_path import predict_long_audio_with_paddle
    table_content = predict_long_audio_with_paddle(audio_path, start_time, state)
    write_to_sheet(book_name_xlsx, sheet_name_xlsx, table_content)
    state[0] = 1
    # 删除中间文件
    # shutil.rmtree(tmp_root)


if __name__ == '__main__':
    start_time = time.time()
    # 给定待处理的视频路径
    video_path = 'D:/heelo/zhanlang.rmvb'

    detect_with_asr(video_path, "zhanlang.xlsx", 50, 5154)
    print("处理视频 {} 需要时长为{} ".format(os.path.basename(video_path), time.time() - start_time))
