# WenetSpeech数据集

10000+小时的普通话语音数据集

![WenetSpeech数据集](images/wenetspeech.jpg)

[WenetSpeech数据集](https://wenet-e2e.github.io/WenetSpeech/) 包含了10000+小时的普通话语音数据集，所有数据均来自 YouTube 和 Podcast。采用光学字符识别(OCR)和自动语音识别(ASR)技术分别标记每个YouTube和Podcast录音。为了提高语料库的质量，WenetSpeech使用了一种新颖的端到端标签错误检测方法来进一步验证和过滤数据。

 - 所有数据分为 3 类，如下表所示：

| 数据分类 |  时长（小时） | 可信度  | 可用系统 |
|:---:|:---:|:---:|:---:|
| 强标签 | 10005 | \>=0.95      | 监督训练 |
| 弱标签 | 2478  | [0.6, 0.95] | 半监督或噪音训练 |
| 无标签 | 9952  | /           | 无监督训练或预训练 |
| 总共  | 22435 | /           | / |

 - 领域、说话风格和场景将高标签分为 10 组，如下表所示：

| 领域      | Youtube（小时） | Podcast（小时） | 全部（小时）  |
|:---:|:---:|:---:|:---:|
| 有声读物   | 0       | 250.9   | 250.9  |
| 现场解说  | 112.6   | 135.7   | 248.3  |
| 纪录片 | 386.7   | 90.5    | 477.2  |
| 戏剧       | 4338.2  | 0       | 4338.2 |
| 采访   | 324.2   | 614     | 938.2  |
| 新闻        | 0       | 868     | 868    |
| 阅读     | 0       | 1110.2  | 1110.2 |
| 讨论        | 204     | 90.7    | 294.7  |
| 综艺     | 603.3   | 224.5   | 827.8  |
| 其他      | 144     | 507.5   | 651.5  |
| 总共       | 6113    | 3892    | 10005  |

 - 3个子集，即S，M并且L对不同的数据规模建设ASR系统

| 训练数据 | 可信度  |  时长（小时） |
|:---:|:---:|:---:|
| L | [0.95, 1.0] | 10005 |
| M | 1.0         | 1000  |
| S | 1.0         | 100   |

 - 评估测试数据

| 评估数据 | 时长（小时） | 来源 | 描述 |
|:---:|:---:|:---:|:---:|
| DEV             | 20    | 互联网     | 专为一些需要在训练中设置交叉验证的语音工具而设计 |
| TEST\_NET       | 23    | 互联网     | 比赛测试 |
| TEST\_MEETING   | 15    | 会议 | 远场、对话、自发和会议数据集  |


1. 本教程介绍如何使用该数据集训练语音识别模型，只是用强标签的数据，主要分三步。下载并解压WenetSpeech数据集，在[官网](https://wenet-e2e.github.io/WenetSpeech/#download) 填写表单之后，会收到邮件，执行邮件上面的三个命令就可以下载并解压数据集了，注意这要500G的磁盘空间。

2. 然后制作数据集，下载原始的数据是没有裁剪的，我们需要根据JSON标注文件裁剪并标注音频文件。在`tools`目录下执行`create_wenetspeech_data.py`程序就可以制作数据集了，注意此时需要3T的磁盘空间。`--wenetspeech_json`参数是指定WenetSpeech数据集的标注文件路径，具体根据读者下载的地址设置。
```shell
cd tools/
python create_wenetspeech_data.py --wenetspeech_json=/media/wenetspeech/WenetSpeech.json
```

3. 最后创建训练数据，跟普通使用一样，在项目根目录执行`create_data.py`就能过生成训练所需的数据列表，词汇表和均值标准差文件。这一步结束后就可以训练模型了，具体看[训练模型](train.md)
```shell
python create_data.py
```

**温馨提示：** 数据集超大，费时费资源，看自己的情况使用，无金刚钻就不要揽瓷器活。