# Copyright (c) Microsoft Corporation.
# Licensed under the MIT license.

gid=$1
source_lg=$2
target_lg=$3
DATA=data/bin/ft_${source_lg}_${target_lg}
BPE_CODES=data/vocab/bpecodes.all
ft_domain=LYRICS
prefix_size=0
SPLIT=$4
model=$5
beam_size=${6}
placeholder=0
SAVE_PATH=$model/inference_results
mkdir -p $SAVE_PATH

task=xdae_multilingual_translation_with_melody

suffix=""

CUDA_VISIBLE_DEVICES=$gid fairseq-generate $DATA \
                    --add-lang-token \
                    --bpe 'fastbpe' \
                    --bpe-codes $BPE_CODES \
                    --beam $beam_size \
                    --distance-reward \
                    --domains LYRICS,WMT \
                    --finetune-data $DATA \
                    --finetune-langs ${source_lg}-${target_lg} \
                    --finetune-domain $ft_domain \
                    --gen-subset $SPLIT \
                    --generate-with-melody \
                    --langs en,zh \
                    --max-sentences 16 \
                    --path $model/checkpoint_best.pt \
                    --placeholder $placeholder \
                    --prefix-size $prefix_size \
                    --print-alignment 'act' \
                    --results-path $SAVE_PATH \
                    --remove-bpe '@@' \
                    --skip-invalid-size-inputs-valid-test \
                    --sacrebleu  \
                    -s ${source_lg}  -t ${target_lg} \
                    --scoring bleu \
                    --tensorboard-logdir $model \
                    --task $task \
                    --no-progress-bar $suffix > ${SAVE_PATH}/${source_lg}-${target_lg}-${SPLIT}

cat ${SAVE_PATH}/${source_lg}-${target_lg}-${SPLIT} | grep -P "^H" |sort -V |cut -f 3- | sed "s/\[$ft_domain\]//g" > ${SAVE_PATH}/$target_lg.$SPLIT.hyp.org
cat ${SAVE_PATH}/${source_lg}-${target_lg}-${SPLIT} | grep -P "^T" |sort -V |cut -f 2- | sed "s/\[$ft_domain\]//g" > ${SAVE_PATH}/$target_lg.$SPLIT.ref
cat ${SAVE_PATH}/${source_lg}-${target_lg}-${SPLIT} | grep -P "^S" |sort -V |cut -f 2- | sed "s/\[$ft_domain\]//g" > ${SAVE_PATH}/$source_lg.$SPLIT.src
cat ${SAVE_PATH}/${source_lg}-${target_lg}-${SPLIT} | grep -P "^A-" |sort -V |cut -f 2- | sed "s/\[$ft_domain\]//g" > ${SAVE_PATH}/$target_lg.$SPLIT.alignment
echo ${model}, ${source_lg}-${target_lg}-${SPLIT}
echo `cat ${SAVE_PATH}/${source_lg}-${target_lg}-${SPLIT} | grep -P "Generate $SPLIT" | xargs`

ossutil -c /home/xiji.lcx/workspace/.ossutilconfig cp -u -r $model/inference_musicxml oss://alitranx-public/xiji.lcx/SongTranslation/results/$model/inference_musicxml
ossutil -c /home/xiji.lcx/workspace/.ossutilconfig cp -u -r $model/inference_results oss://alitranx-public/xiji.lcx/SongTranslation/results/$model/inference_results
#CUDA_VISIBLE_DEVICES=$gid fairseq-generate $DATA \
#                    --add-lang-token \
#                    --bpe 'fastbpe' \
#                    --bpe-codes $BPE_CODES \
#                    --beam $beam_size \
#                    --distance-reward \
#                    --domains LYRICS,WMT \
#                    --finetune-data $DATA \
#                    --finetune-langs ${source_lg}-${target_lg} \
#                    --finetune-domain $ft_domain \
#                    --gen-subset $SPLIT \
#                    --generate-with-melody \
#                    --langs en,zh \
#                    --max-sentences 16 \
#                    --path $model/checkpoint_best.pt \
#                    --placeholder $placeholder \
#                    --prefix-size $prefix_size \
#                    --print-alignment 'act' \
#                    --results-path $SAVE_PATH \
#                    --remove-bpe '@@' \
#                    --skip-invalid-size-inputs-valid-test \
#                    --sacrebleu  \
#                    -s ${source_lg}  -t ${target_lg} \
#                    --scoring align_dist \
#                    --tensorboard-logdir $model \
#                    --task $task \
#                    --no-progress-bar $suffix > ${SAVE_PATH}/${source_lg}-${target_lg}-${SPLIT}
#
#echo ${model}, ${source_lg}-${target_lg}-${SPLIT}
#echo `cat ${SAVE_PATH}/${source_lg}-${target_lg}-${SPLIT} | grep -P "Generate $SPLIT" | xargs`
#                    --save-results \
#cp $DATA/${SPLIT}_tgt_len ${SAVE_PATH}/${SPLIT}_tgt_len
#                    --save-results \
#if [[ $suffix == "" ]]
#then
#    cp ${SAVE_PATH}/$target_lg.$SPLIT.hyp.org ${SAVE_PATH}/$target_lg.$SPLIT.hyp
#else
#    python ./restore_group.py $DATA/${SPLIT}.notes.group.pitches_dur ${SAVE_PATH}/$target_lg.$SPLIT.hyp.org ${SAVE_PATH}/$target_lg.$SPLIT.hyp
#fi
