# Copyright (c) Microsoft Corporation.
# Licensed under the MIT license.

gid=$1
source_lg=$2
target_lg=$3
#DATA=data/bin/${source_lg}_${target_lg}
DATA=data/bin/ft_${source_lg}_${target_lg}
BPE_CODES=data/vocab/bpecodes.all
ft_domain=LYRICS
prefix_size=1
SPLIT=test
model=$4
beam_size=5
lyrics_dict=data/vocab/vocab.all.truncated
notes_weight=1.0
shape_weight=1.0
durations_weight=1.0
rests_weight=1.0
min_align_prob=0.01
SAVE_PATH=$model/inference_results
placeholder=0
max_pos=4096

mkdir -p $SAVE_PATH

task=xdae_multilingual_translation_decoder_length

suffix=""
if [ $# -eq 18 && ${18} == "with_group" ]; then
    suffix="--with-predefined-notes-group"
fi


CUDA_VISIBLE_DEVICES=$gid fairseq-generate $DATA \
                    --finetune-data $DATA \
                    -t ${target_lg} -s ${source_lg} \
                    --finetune-langs ${source_lg}-${target_lg} \
                    --path $model/checkpoint_best.pt \
                    --with-predefined-notes-group \
                    --task $task \
                    --skip-invalid-size-inputs-valid-test \
                    --gen-subset $SPLIT \
                    --distance-reward \
                    --notes-weight $notes_weight \
                    --durations-weight $durations_weight \
                    --rests-weight $rests_weight \
                    --shape-weight $shape_weight \
                    --min-align-prob $min_align_prob \
                    --langs en,zh \
                    --placeholder $placeholder \
                    --domains LYRICS,WMT \
                    --ft-domain $ft_domain \
                    --add-lang-token \
                    --align-notes \
                    --prefix-size $prefix_size \
                    --mono-ratio 0.0 \
                    --bpe 'fastbpe' \
                    --bpe-codes $BPE_CODES \
                    --sacrebleu  \
                    --scoring 'bleu' \
                    --remove-bpe '@@' \
                    --max-sentences 16 \
                    --beam $beam_size \
                    --max-source-positions $max_pos \
                    --max-target-positions $max_pos \
                    --no-progress-bar $suffix > ${SAVE_PATH}/${source_lg}-${target_lg}-${SPLIT}

cat ${SAVE_PATH}/${source_lg}-${target_lg}-${SPLIT} | grep -P "^H" |sort -V |cut -f 3- | sed "s/\[$ft_domain\]//g" > ${SAVE_PATH}/$target_lg.$SPLIT.hyp.org
cat ${SAVE_PATH}/${source_lg}-${target_lg}-${SPLIT} | grep -P "^T" |sort -V |cut -f 2- | sed "s/\[$ft_domain\]//g" > ${SAVE_PATH}/$target_lg.$SPLIT.ref
cat ${SAVE_PATH}/${source_lg}-${target_lg}-${SPLIT} | grep -P "^S" |sort -V |cut -f 2- | sed "s/\[$ft_domain\]//g" > ${SAVE_PATH}/$source_lg.$SPLIT.src
echo `cat ${SAVE_PATH}/${source_lg}-${target_lg}-${SPLIT} | grep -P "Generate $SPLIT" | xargs`

ossutil -c /home/xiji.lcx/workspace/.ossutilconfig cp -u -r $model/inference_results oss://alitranx-public/xiji.lcx/SongTranslation/results/$model/inference_results
#cp $DATA/${SPLIT}_tgt_len ${SAVE_PATH}/${SPLIT}_tgt_len
#                    --lyrics-dict $lyrics_dict \
#if [[ $suffix == "" ]]
#then
#    cp ${SAVE_PATH}/$target_lg.$SPLIT.hyp.org ${SAVE_PATH}/$target_lg.$SPLIT.hyp
#else
#    python ./restore_group.py $DATA/${SPLIT}.notes.group.pitches_dur ${SAVE_PATH}/$target_lg.$SPLIT.hyp.org ${SAVE_PATH}/$target_lg.$SPLIT.hyp
#fi
